/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.core.world.feature.SurfaceParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.world.WorldGenDecoration;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class DecorationParser
extends SurfaceParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (!jsonObject.has("genSurface")) {
            logger.info("Entry does not specify genSurface for 'decoration' generator. Using grass.");
            arrayList.add(new WeightedRandomBlock((Block)Blocks.grass));
        } else if (!FeatureParser.parseResList(jsonObject.get("genSurface"), arrayList, false)) {
            logger.warn("Entry specifies invalid genSurface for 'decoration' generator! Using grass!");
            arrayList.clear();
            arrayList.add(new WeightedRandomBlock((Block)Blocks.grass));
        }
        WorldGenDecoration worldGenDecoration = new WorldGenDecoration(list, n, list2, arrayList);
        if (jsonObject.has("genSky")) {
            worldGenDecoration.seeSky = jsonObject.get("genSky").getAsBoolean();
        }
        if (jsonObject.has("checkStay")) {
            worldGenDecoration.checkStay = jsonObject.get("checkStay").getAsBoolean();
        }
        if (jsonObject.has("stackHeight")) {
            worldGenDecoration.stackHeight = jsonObject.get("stackHeight").getAsInt();
        }
        if (jsonObject.has("xVariance")) {
            worldGenDecoration.xVar = MathHelper.clamp(jsonObject.get("xVariance").getAsInt(), 1, 15);
        }
        if (jsonObject.has("yVariance")) {
            worldGenDecoration.yVar = MathHelper.clamp(jsonObject.get("yVariance").getAsInt(), 0, 15);
        }
        if (jsonObject.has("zVariance")) {
            worldGenDecoration.zVar = MathHelper.clamp(jsonObject.get("zVariance").getAsInt(), 1, 15);
        }
        return worldGenDecoration;
    }

    @Override
    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.air, -1));
    }

    @Override
    protected String getDefaultTemplate() {
        return "decoration";
    }
}

